package kb.business;

// Imports Enhydra
import com.lutris.appserver.server.Enhydra;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.logging.*;
import com.lutris.dods.builder.generator.query.*;
import com.lutris.appserver.server.sql.*;
import kb.data.*;

public class kbManager {
  protected LogChannel log = Enhydra.getLogChannel();

  /**
   * Retourne un tableau de InfoDOs satisfaisant la requte de l'utilisateur
   *  partir du prnom et du nom spcifis
   */
  public InfoDO[] getNames(String pstype, String pstitre, String pscontenu) {
    InfoDO[] list = null;    
    boolean empty = true;
    try {
      InfoQuery pq = new InfoQuery();
      QueryBuilder qb = pq.getQueryBuilder();
      if (pstype != null && pstype.length() > 0) {
        qb.addWhereLower(InfoDO.Type, "%" + pstype.toLowerCase() + "%", "LIKE");
      } 
      if (pstitre != null && pstitre.length() > 0) {
        qb.addWhereLower(InfoDO.Titre, "%" + pstitre.toLowerCase() + "%", "LIKE");
      } 
      if (pscontenu != null && pscontenu.length() > 0) {
        qb.addWhereLower(InfoDO.Contenu, "%" + pscontenu.toLowerCase() + "%", "LIKE");
      } 
      list = pq.getDOArray();
    } catch (Exception e) {
      log.write(Logger.CRITICAL, "Exception dans kbManager");
      log.write(Logger.CRITICAL, e.toString());
    } 
    return list;
  } 

  /**
   * Retourne le InfoDO associ  l'info correspondant au handle / oid spcifi
   */
  public InfoDO getInfo(String handle) {
    InfoDO info = null;
    if (handle == null || handle.equals("")) {
      return info;
    } 
    try {
      InfoQuery pq = new InfoQuery();
      pq.setQueryOId(new ObjectId(handle));
      info = (pq.getDOArray())[0];
    } catch (Exception e) {
      log.write(Logger.CRITICAL, "Exception dans kbManager");
      log.write(Logger.CRITICAL, e.toString());
    } 
    return info;
  } 
}
